#include <iostream>
#include <vector>
#include <set>

using namespace std;

#define ubrzaj ios_base::sync_with_stdio(false); cin.tie(NULL); cout.tie(NULL);
typedef long long ll;

struct NajboljihK {
    int k_broj;
    ll trenutna_suma = 0;
    multiset<ll> manji, ostali;

    NajboljihK(int k) : k_broj(k) {}

    void dodaj(ll vrednost) {
        manji.insert(vrednost);
        trenutna_suma += vrednost;
        if (manji.size() > k_broj) {
            auto it = prev(manji.end());
            trenutna_suma -= *it;
            ostali.insert(*it);
            manji.erase(it);
        }
    }

    void ukloni(ll vrednost) {
        if (manji.find(vrednost) != manji.end()) {
            trenutna_suma -= vrednost;
            manji.erase(manji.find(vrednost));
            if (!ostali.empty()) {
                auto it = ostali.begin();
                trenutna_suma += *it;
                manji.insert(*it);
                ostali.erase(it);
            }
        } else {
            ostali.erase(ostali.find(vrednost));
        }
    }
};

int main() {
    ubrzaj;

    int n, m, k_krajnje;
    cin >> n >> m >> k_krajnje;

    vector<ll> a(n + 1);
    vector<ll> prefiks(n + 1, 0);
    for (int i = 1; i <= n; i++) {
        cin >> a[i];
        prefiks[i] = prefiks[i - 1] + a[i];
    }

    NajboljihK struktura(k_krajnje - 1);

    for (int i = 0; i < m; i++) {
        struktura.dodaj(prefiks[i]);
    }

    for (int i = 1; i <= n - m + 1; i++) {
        int pocetak = i - 1;
        int kraj = i + m - 1;

        ll suma_prozora = prefiks[kraj] - prefiks[pocetak];
        ll maksimalna_aura = suma_prozora + (ll)(k_krajnje - 1) * prefiks[kraj] - struktura.trenutna_suma;

        cout << maksimalna_aura << (i == n - m + 1 ? "" : " ");

        if (i <= n - m) {
            struktura.ukloni(prefiks[pocetak]);
            struktura.dodaj(prefiks[kraj]);
        }
    }
    cout << endl;

    return 0;
}
/*#include <iostream>
#include <vector>
#include <set>

using namespace std;

typedef long long ll;

struct ????????? {
    int ?_????;
    ll ????????_???? = 0;
    multiset<ll> ????, ??????;

    ?????????(int ?) : ?_????(?) {}

    void ?????(ll ????????) {
        ????.insert(????????);
        ????????_???? += ????????;
        if (????.size() > ?_????) {
            auto it = prev(????.end());
            ????????_???? -= *it;
            ??????.insert(*it);
            ????.erase(it);
        }
    }

    void ??????(ll ????????) {
        if (????.find(????????) != ????.end()) {
            ????????_???? -= ????????;
            ????.erase(????.find(????????));
            if (!??????.empty()) {
                auto it = ??????.begin();
                ????????_???? += *it;
                ????.insert(*it);
                ??????.erase(it);
            }
        } else {
            ??????.erase(??????.find(????????));
        }
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(NULL);

    int n, m, k_??????;
    cin >> n >> m >> k_??????;

    vector<ll> ?(n + 1);
    vector<ll> ???????(n + 1, 0);
    for (int i = 1; i <= n; i++) {
        cin >> ?[i];
        ???????[i] = ???????[i - 1] + ?[i];
    }

    ????????? ?????????(k_?????? - 1);

    for (int i = 0; i < m; i++) {
        ?????????.?????(???????[i]);
    }

    for (int i = 1; i <= n - m + 1; i++) {
        int ??????? = i - 1;
        int ???? = i + m - 1;

        ll ????_??????? = ???????[????] - ???????[???????];
        ll ??????????_???? = ????_??????? + (ll)(k_?????? - 1) * ???????[????] - ?????????.????????_????;

        cout << ??????????_???? << (i == n - m + 1 ? "" : " ");

        if (i <= n - m) {
            ?????????.??????(???????[???????]);
            ?????????.?????(???????[????]);
        }
    }
    cout << endl;

    return 0;
}*/